async function avancarPag() {
    if ($("#txtCodigo").val() == "") {
        $("#txtCodigo").val(0);
    }
    if ($("#txtDescricao").val() == "") {
        $("#txtDescricao").val(" ");
    }

    currentFs = $(this).parent();
    nextFs = $(this).parent().next();

    $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

    nextFs.show();
    currentFs.animate(
        {
            opacity: 0,
        },
        {
            step(now) {
                opacity = 1 - now;

                currentFs.css({
                    display: "none",
                    position: "relative",
                });
                nextFs.css({
                    'opacity': opacity
                });
            },
            duration: 600,
        }
    );
}

/* eslint-disable prefer-rest-params */
$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if (Element.node.id == "avancar1") {
                    avancarPag()
                    $("#avancar1").trigger("click");
                }
            },
            onPrevious: (Element) => {
                if (Element.node.id == "tutOpcoes") {
                    $("#voltar2").trigger("click");
                }
            },
        });

        driver.defineSteps([{
            element: '#conteudo',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código do Setor',
                description: 'Neste campo adicionamos o código do setor.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o registro que estamos cadastrando ou alterando.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: "#avancar1",
            popover: {
                title: "Botão Avançar",
                description: "Clique aqui para ir para a próxima aba.",
                position: "left",
            },
        },
        {
            element: "#tutOpcoes",
            popover: {
                title: "Opções",
                description: "Aqui estão as configurações do setor.",
                position: "top",
            },
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o setor.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $(function () {

        $('#txtPreco').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });
        $('#txtCusto').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let codigo = parametros[parametros.length - 1];

    let contaFs = 1;

    $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCentroCusto').autocompleta(1, `JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtTerceiro').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI chave", "NOME descricao"], "where": null}`);

    $('#btnGrupo').pesquisa_serverside(['#txtGrupo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CADFLUXO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Grupo');
    $('#btnCentroCusto').pesquisa_serverside(['#txtCentroCusto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CENTROCUSTO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Centro de Custo');
    $('#btnDeposito').pesquisa_serverside(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"DEPOSITO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Depósito');
    $('#btnTerceiro').pesquisa_serverside(['#txtTerceiro'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "NOME", "CODCLI"], "where": null}', 'Pesquisa de Entidade');

    componenteFiltro('setor', false, false, 'SetorQual')

    $('#btnLimpaGrupo').on('click', function () {
        $('#txtGrupo').val('');
    });
    $('#btnLimpaCentroCusto').on('click', function () {
        $('#txtCentroCusto').val('');
    });
    $('#btnLimpaDeposito').on('click', function () {
        $('#txtDeposito').val('');
    });
    $('#btnLimpaTerceiro').on('click', function () {
        $('#txtTerceiro').val('');
    });

    $(".next").click(function () {

        contaFs += 1;

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {

            currentFs = $(this).parent();
            nextFs = $(this).parent().next();

            $("#progressbar li").eq($("#msform > fieldset").index(nextFs)).addClass("active");

            nextFs.show();
            currentFs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;

                    currentFs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    nextFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
        }
    });

    $(".previous").click(function () {
        contaFs -= 1;

        currentFs = $(this).parent();
        previousFs = $(this).parent().prev();
        $("#progressbar li")
            .eq($("#msform > fieldset").index(currentFs))
            .removeClass("active");
        previousFs.show();
        currentFs.animate(
            {
                opacity: 0,
            },
            {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        display: "none",
                        position: "relative",
                    });
                    previousFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600,
            }
        );
    });

    $("#account").on("click", function () {
        if (codigo != "create") {
            if (contaFs == 2) {
                $("#voltar2").trigger("click");
            }
        }
    });

    $("#payment").on("click", function () {
        if (codigo != "create") {
            if (contaFs == 1) {
                $("#avancar1").trigger("click");
            }
        }
    });

    $(document).ready(function () {
        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtCodigo: {
                    required: true,
                },
                txtDescricao: {
                    required: true,
                }
            },
            messages: {
                txtCodigo: {
                    required: "Informe um código válido."
                },
                txtDescricao: {
                    required: "Informe uma descrição válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CADSETOR', getCookie('usuario'), codigo);
        window.location.href = `${BASE_URI}/cadsetor`;
    });

    $('#txtCodigo').on('blur', async function () {
        if (codigo === 'create') {
            const codigo = $('#txtCodigo').val();
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"CADFLUXO",
                    "camposSelect":["CODIGO"], 
                    "where": ["CODIGO = '${codigo}'"]}`, null);

            let json = await response.json();
            if (json.RESULT[0].length > 0) {
                msgAlerta('Código já existe. Favor verifique!');
                return;
            }
        }
    });

    $('#cbSugerePrecoAnt').on('click', function(){
        if ($(this).is(':checked')){
            $('#cbGravarUnitario').prop('checked', false)
        }
    })

    $('#cbGravarUnitario').on('click', function(){
        if ($(this).is(':checked')){
            $('#cbSugerePrecoAnt').prop('checked', false)
        }
    })

    async function carregaDadosSetor(setor) {
        $('#txtCodigo').val(setor.CODIGO);
        $('#txtDescricao').val(setor.DESCRICAO);
        $('#txtPreco').val(setor.PRECO);
        $('#txtCusto').val(setor.CUSTO);
        // fazer daqui
        if (setor.TIPO_LEADTIME == 0) {
            $('#radioTempoProduto').prop('checked', true)
        }
        else if (setor.TIPO_LEADTIME == 1) {
            $('#radioMaquina').prop('checked', true)
        } else if (setor.TIPO_LEADTIME == 2) {
            $('#radioTempoSetor').prop('checked', true)
        }
        $('#txtOrdem').val(setor.ORDEM)
        $('#txtDias').val(setor.DIAS)
        $('#txtPecas').val(setor.PECAS_DIA)
        $('#txtTempoPadrao').val(setor.TEMPO)
        $('#txtIndInventario').val(setor.IND_INV)
        $('#txtConcTempos').val(setor.CONC_TEMPOS)
        $('#txtPercPontualidade').val(setor.PERC_PONTUALIDADE)
        $('#txtPercQual').val(setor.PERC_QUAL)
        $('#txtPerc100').val(setor.PERC_100)
        insereValor('#txtSetorQual', setor.SETOR_QUAL, {tabela: 'CADFLUXO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: setor.SETOR_QUAL});
        try {
            let responseGrupo = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"CADFLUXO", 
            "camposSelect":["descricao"], 
            "where": ["codigo = '${setor.GRUPO}'"]}`, null);

            if (!responseGrupo) {
                return;
            }
            let jsonStrGrupo = await responseGrupo.json();
            if (responseGrupo.status != 200) {
                msgErro(jsonStrClasse.RESULT[0].mensagem);
                return;
            }

            insereValor('#txtGrupo', setor.GRUPO, jsonStrGrupo.RESULT[0][0].DESCRICAO);

        } catch (error) {
            console.error(error);
        }

        try {
            let responseCentroCusto = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"CENTROCUSTO", 
            "camposSelect":["descricao"], 
            "where": ["codigo = '${setor.CENTRO_CUSTO}'"]}`, null);

            if (!responseCentroCusto) {
                return;
            }
            let jsonStrCentroCusto = await responseCentroCusto.json();
            if (responseCentroCusto.status != 200) {
                msgErro(jsonStrClasse.RESULT[0].mensagem);
                return;
            }

            insereValor('#txtCentroCusto', setor.CENTRO_CUSTO, jsonStrCentroCusto.RESULT[0][0].DESCRICAO);

        } catch (error) {
            console.error(error);
        }

        try {
            let responseDeposito = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"DEPOSITO", 
            "camposSelect":["descricao"], 
            "where": ["codigo = '${setor.DEPOSITO}'"]}`, null);

            if (!responseDeposito) {
                return;
            }
            let jsonStrDeposito = await responseDeposito.json();
            if (responseDeposito.status != 200) {
                msgErro(jsonStrClasse.RESULT[0].mensagem);
                return;
            }

            insereValor('#txtDeposito', setor.DEPOSITO, jsonStrDeposito.RESULT[0][0].DESCRICAO);

        } catch (error) {
            console.error(error);
        }

        try {
            let responseTerceiro = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"ENTIDADE", 
            "camposSelect":["NOME"], 
            "where": ["CODCLI = '${setor.TERCEIRO}'"]}`, null);

            if (!responseTerceiro) {
                return;
            }
            let jsonStrTerceiro = await responseTerceiro.json();
            if (responseTerceiro.status != 200) {
                msgErro(jsonStrClasse.RESULT[0].mensagem);
                return;
            }

            insereValor('#txtTerceiro', setor.TERCEIRO, jsonStrTerceiro.RESULT[0][0].NOME);

        } catch (error) {
            console.error(error);
        }
        $('#txtContaSped').val(setor.CONTA_SPED)
        //checkbox
        $('#cbAlterarPreco').prop('checked', setor.ALT_PRECO == 'S')
        $('#cbInventario').prop('checked', setor.INVENTARIO == 'S')
        $('#cbBaixarQtdeOf').prop('checked', setor.BAIXAMAIOR == 'S')
        $('#cbObrigaMovto').prop('checked', setor.BAIXAMOV == 'S')
        $('#cbPrevisao').prop('checked', setor.IMP_FLUXO == 'S')
        $('#cbImprimir').prop('checked', setor.IMP_REL == 'S')
        $('#cbControlaPreco').prop('checked', setor.CONTR_PRECO == 'S')
        $('#cbPerguntaReserva').prop('checked', setor.DEL_RESERVA == 'S')
        $('#cbQtdeZerada').prop('checked', setor.ZERA_QTDE == 'S')
        $('#cbAgrupaProd').prop('checked', setor.CONTROLA_PROD == 'S')
        $('#cbExigeNota').prop('checked', setor.OBRIGA_NOTA == 'S')
        $('#cbDesconsideraSetor').prop('checked', setor.DESCONSIDERA_WFL == 'S')
        $('#cbCalculaPreco').prop('checked', setor.PRECO_MINUTO == 'S')
        $('#cbAbrirRelProcessos').prop('checked', setor.ABRE_PROCESSO == 'S')
        $('#cbPermiteAlterarCor').prop('checked', setor.ALT_COR_FACCAO == 'S')
        $('#cbPermiteDistribuicao').prop('checked', setor.DISTR_PACOTES == 'S')
        $('#cbUsaBarra').prop('checked', setor.USA_BARRA_FAC == 'S')
        $('#cbAtualizarQtde').prop('checked', setor.HABILITA_QTDE_OF == 'S')
        $('#cbQtdeTotal').prop('checked', setor.QTDE_TOTAL_OF == 'S')
        $('#cbCodigoPorCaixa').prop('checked', setor.GERA_CAIXA == 'S')
        $('#cbMotivoEsotrno').prop('checked', setor.OBRIGA_MOTIVO == 'S')
        $('#cbGuardaMovto').prop('checked', setor.GUARDAR_MOVIMENTO == 'S')
        $('#cbGuardaMovto2').prop('checked', setor.GUARDAR_MOVIMENTO_2 == 'S')
        $('#cbGuardaMovto3').prop('checked', setor.GUARDAR_MOVIMENTO_3 == 'S')
        $('#cbMovtoPartes').prop('checked', setor.MOV_PARTES == 'S')
        $('#cbPedidoCliente').prop('checked', setor.DESCONSIDERA_PEDCLI == 'S')
        $('#cbReferencia').prop('checked', setor.CALC_AGENDAMENTO == 'S')
        $('#cbDesperdicio').prop('checked', setor.ABRE_CADDESP == 'S')
        $('#cbSetorLeadTime').prop('checked', setor.SETOR_LEADTIME == 'S')
        $('#cbFechamento').prop('checked', setor.FECHA_PARTES == 'S')
        $('#cbApontamento').prop('checked', setor.ALT_CLIENTE_FAC == 'S')
        $('#cbDemanda').prop('checked', setor.PROG_DEMANDA == 'S')
        $('#cbABVTEX').prop('checked', setor.CONTR_CERT == 'S')
        $('#cbAlterarOrdem').prop('checked', setor.ALT_ORDEM == 'S')
        $('#cbBaixaConsumos').prop('checked', setor.CONS_BENEF == 'S')
        $('#cbBaixaSubProduto').prop('checked', setor.EXP_SUBPROD == 'S')
        $('#cbFilaFechada').prop('checked', setor.FILA_FECHADA == 'S')
        $('#cbContagemSped').prop('checked', setor.CONTAGEM_SPED == 'S')
        $('#cbBaixarConsumoSetor').prop('checked', setor.BAIXA_CONS_SETOR == 'S')
        $('#cbEnviaConsumo').prop('checked', setor.FAC_ENV_CONS == 'S')
        $('#cbConsideraSetor').prop('checked', setor.CONSIDERA_MPS == 'S')
        $('#cbApontamentoProducao').prop('checked', setor.APONT_PRODUCAO == 'S')
        $('#cbApontamentoCelula').prop('checked', setor.ENV_CLIENTE_FAC == 'S')
        $('#cbConsiderarCustos').prop('checked', setor.CONS_CUSTO == 'S')
        $('#cbPrecoLavanderia').prop('checked', setor.PRECO_LAVANDERIA == 'S')
        $('#cbFormacaoKits').prop('checked', setor.FORMACAO_KITS == 'S')
        $('#cbConsiderarRfid').prop('checked', setor.CONS_QTDE_RFID == 'S')
        $('#cbConsiderarFila').prop('checked', setor.DISTR_FILA == 'S')
        $('#cbConsiderarAnalise').prop('checked', setor.ANALISE_PRAZO == 'S')
        $('#cbExcluirCaixa').prop('checked', setor.EXCLUIR_CAIXA == 'S')
        $('#cbAtualizarCaixa').prop('checked', setor.ATUALIZA_CAIXA == 'S')
        $('#cbPrecoFaccao').prop('checked', setor.PRECOFAC_CORTAM == 'S')
        $('#cbMovEstoque').prop('checked', setor.MOV_ESTOQUE == 'S')
        $('#cbObrigaProgramacao').prop('checked', setor.OBRIGA_PROGRAMACAO == 'S')
        $('#cbConsideraEstoqueVenda').prop('checked', setor.CONS_ESTOQUEVENDA == 'S')
        $('#cbImprimeEtiquetaComposicao').prop('checked', setor.IMP_ETQ_COMPOSI == 'S')
        $('#cbHabilitarEnfesto').prop('checked', setor.HAB_ENFESTO_MOV == 'S')
        $('#cbObrigaLaudo').prop('checked', setor.OBRIGA_LAUDO == 'S')
        $('#cbGravarUnitario').prop('checked', setor.GRAVAR_UNITARIO == 'S')
        $('#cbSugerePrecoAnt').prop('checked', setor.SUGERE_PRECOANT == 'S')
        //até aqui

        if (setor.ATIVO == 'S') {
            $('#checkAtivo').prop('checked', true);
        } else {
            $('#checkAtivo').prop('checked', false);
        }
        if (setor.TIPO == 'P') {
            $('#radioProduto').prop('checked', true);
        }
        if (setor.TIPO == 'M') {
            $('#radioMaterial').prop('checked', true);
        }
        if (setor.TIPO == 'V') {
            $('#radioVenda').prop('checked', true);
        }
    }

    if (codigo != '' && codigo != 'create') {
        if (await liberarRegistro('CADSETOR', codigo) == false) {
            window.location.href = '../cadsetor';
        } else {
            try {
                $.LoadingOverlay("show");

                try {
                    $('#txtCodigo').attr('disabled', 'disabled');
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"CADFLUXO", 
                            "camposSelect":["CODIGO", "DESCRICAO", "ATIVO", "PRECO", "CUSTO", "TIPO",
                                            "TIPO_LEADTIME","ORDEM","DIAS","PECAS_DIA","TEMPO","IND_INV","CONC_TEMPOS",
                                            "PERC_PONTUALIDADE","PERC_QUAL","PERC_100","GRUPO","CENTRO_CUSTO","DEPOSITO","TERCEIRO","CONTA_SPED","ALT_PRECO","INVENTARIO",
                                            "BAIXAMAIOR","BAIXAMOV","IMP_FLUXO","IMP_REL","CONTR_PRECO","DEL_RESERVA","ZERA_QTDE","CONTROLA_PROD","OBRIGA_NOTA",
                                            "DESCONSIDERA_WFL","PRECO_MINUTO","ABRE_PROCESSO","ALT_COR_FACCAO","DISTR_PACOTES","USA_BARRA_FAC","HABILITA_QTDE_OF",
                                            "QTDE_TOTAL_OF","GERA_CAIXA","OBRIGA_MOTIVO","GUARDAR_MOVIMENTO","GUARDAR_MOVIMENTO_2","GUARDAR_MOVIMENTO_3","MOV_PARTES",
                                            "DESCONSIDERA_PEDCLI","CALC_AGENDAMENTO","ABRE_CADDESP","SETOR_LEADTIME","FECHA_PARTES","ALT_CLIENTE_FAC","PROG_DEMANDA",
                                            "CONTR_CERT","ALT_ORDEM","CONS_BENEF","EXP_SUBPROD","FILA_FECHADA","CONTAGEM_SPED","BAIXA_CONS_SETOR","FAC_ENV_CONS",
                                            "CONSIDERA_MPS","APONT_PRODUCAO","ENV_CLIENTE_FAC","CONS_CUSTO","PRECO_LAVANDERIA","FORMACAO_KITS","CONS_QTDE_RFID",
                                            "DISTR_FILA","ANALISE_PRAZO","EXCLUIR_CAIXA","ATUALIZA_CAIXA","PRECOFAC_CORTAM","MOV_ESTOQUE","OBRIGA_PROGRAMACAO", "IMP_ETQ_COMPOSI", 
                                            "CONS_ESTOQUEVENDA", "HAB_ENFESTO_MOV", "OBRIGA_LAUDO", "SETOR_QUAL", "GRAVAR_UNITARIO", "SUGERE_PRECOANT"], 
                            "where": ["CODIGO = '${codigo}'"]}`, null);

                    let json = await response.json();

                    let setor = json.RESULT[0][0]

                    await carregaDadosSetor(setor)
                } catch (error) {
                    console.error(error);
                }

            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    function preencheClasseSetor(setor) {
        setor.CODIGO = $('#txtCodigo').val();
        setor.DESCRICAO = $('#txtDescricao').val().toUpperCase();
        setor.PRECO = parseFloat($('#txtPreco').val());
        setor.CUSTO = parseFloat($('#txtCusto').val());
        setor.ATIVO = $('#checkAtivo').prop('checked') ? setor.ATIVO = 'S' : setor.ATIVO = 'N';
        if ($('#radioTempoProduto').prop('checked')) {
            setor.LEADTIME = 0
        } else if ($('#radioMaquina').prop('checked')) {
            setor.LEADTIME = 1
        } else if ($('#radioTempoSetor').prop('checked')) {
            setor.LEADTIME = 2
        } else {
            setor.LEADTIME = -1
        }
        setor.ORDEM = $('#txtOrdem').val() == '' ? '0' : $('#txtOrdem').val();
        setor.DIAS = $('#txtDias').val()
        setor.PECAS = $('#txtPecas').val()
        setor.TEMPOPADRAO = $('#txtTempoPadrao').val()
        setor.INDINVENTARIO = $('#txtIndInventario').val()
        setor.CONCTEMPOS = $('#txtConcTempos').val()
        setor.PERCPONTUALIDADE = $('#txtPercPontualidade').val()
        setor.PERCQUALIDADE = $('#txtPercQual').val()
        setor.PERC100 = $('#txtPerc100').val()
        setor.GRUPO = pegaChave('#txtGrupo')
        setor.CENTROCUSTO = pegaChave('#txtCentroCusto')
        setor.DEPOSITO = pegaChave('#txtDeposito')
        setor.TERCEIRO = pegaChave('#txtTerceiro')
        setor.CONTASPED = $('#txtContaSped').val()
        setor.SETORQUAL = pegaChave('#txtSetorQual')
        //checkbox
        setor.ALTERARPRECO = $('#cbAlterarPreco').is(':checked') ? 'S' : 'N'
        setor.INVENTARIO = $('#cbInventario').is(':checked') ? 'S' : 'N'
        setor.BAIXARQTDEOF = $('#cbBaixarQtdeOf').is(':checked') ? 'S' : 'N'
        setor.OBRIGAMOVTO = $('#cbObrigaMovto').is(':checked') ? 'S' : 'N'
        setor.PREVISAO = $('#cbPrevisao').is(':checked') ? 'S' : 'N'
        setor.IMPRIMIR = $('#cbImprimir').is(':checked') ? 'S' : 'N'
        setor.CONTROLAPRECO = $('#cbControlaPreco').is(':checked') ? 'S' : 'N'
        setor.PERGUNTARESERVA = $('#cbPerguntaReserva').is(':checked') ? 'S' : 'N'
        setor.QTDEZERADA = $('#cbQtdeZerada').is(':checked') ? 'S' : 'N'
        setor.AGRUPAPROD = $('#cbAgrupaProd').is(':checked') ? 'S' : 'N'
        setor.EXIGENOTA = $('#cbExigeNota').is(':checked') ? 'S' : 'N'
        setor.DESCONSIDERASETOR = $('#cbDesconsideraSetor').is(':checked') ? 'S' : 'N'
        setor.CALCULAPRECO = $('#cbCalculaPreco').is(':checked') ? 'S' : 'N'
        setor.ABRIRRELPROCESSOS = $('#cbAbrirRelProcessos').is(':checked') ? 'S' : 'N'
        setor.PERMITEALTERARCOR = $('#cbPermiteAlterarCor').is(':checked') ? 'S' : 'N'
        setor.PERMITEDISTRIBUICAO = $('#cbPermiteDistribuicao').is(':checked') ? 'S' : 'N'
        setor.USABARRA = $('#cbUsaBarra').is(':checked') ? 'S' : 'N'
        setor.ATUALIZARQTDE = $('#cbAtualizarQtde').is(':checked') ? 'S' : 'N'
        setor.QTDETOTAL = $('#cbQtdeTotal').is(':checked') ? 'S' : 'N'
        setor.CODIGOPORCAIXA = $('#cbCodigoPorCaixa').is(':checked') ? 'S' : 'N'
        setor.MOTIVOESTORNO = $('#cbMotivoEsotrno').is(':checked') ? 'S' : 'N'
        setor.GUARDAMOVTO = $('#cbGuardaMovto').is(':checked') ? 'S' : 'N'
        setor.GUARDAMOVTO2 = $('#cbGuardaMovto2').is(':checked') ? 'S' : 'N'
        setor.GUARDAMOVTO3 = $('#cbGuardaMovto3').is(':checked') ? 'S' : 'N'
        setor.MOVTOPARTES = $('#cbMovtoPartes').is(':checked') ? 'S' : 'N'
        setor.PEDIDOCLIENTE = $('#cbPedidoCliente').is(':checked') ? 'S' : 'N'
        setor.REFERENCIA = $('#cbReferencia').is(':checked') ? 'S' : 'N'
        setor.DESPERDICIO = $('#cbDesperdicio').is(':checked') ? 'S' : 'N'
        setor.SETORLEADTIME = $('#cbSetorLeadTime').is(':checked') ? 'S' : 'N'
        setor.FECHAMENTO = $('#cbFechamento').is(':checked') ? 'S' : 'N'
        setor.APONTAMENTO = $('#cbApontamento').is(':checked') ? 'S' : 'N'
        setor.DEMANDA = $('#cbDemanda').is(':checked') ? 'S' : 'N'
        setor.ABVTEX = $('#cbABVTEX').is(':checked') ? 'S' : 'N'
        setor.ALTERARORDEM = $('#cbAlterarOrdem').is(':checked') ? 'S' : 'N'
        setor.BAIXACONSUMO = $('#cbBaixaConsumos').is(':checked') ? 'S' : 'N'
        setor.BAIXASUBPRODUTO = $('#cbBaixaSubProduto').is(':checked') ? 'S' : 'N'
        setor.FILAFECHADA = $('#cbFilaFechada').is(':checked') ? 'S' : 'N'
        setor.CONTAGEMSPED = $('#cbContagemSped').is(':checked') ? 'S' : 'N'
        setor.BAIXARCONSUMOSETOR = $('#cbBaixarConsumoSetor').is(':checked') ? 'S' : 'N'
        setor.ENVIACONSUMO = $('#cbEnviaConsumo').is(':checked') ? 'S' : 'N'
        setor.CONSIDERASETOR = $('#cbConsideraSetor').is(':checked') ? 'S' : 'N'
        setor.APONTAMENTOPRODUCAO = $('#cbApontamentoProducao').is(':checked') ? 'S' : 'N'
        setor.APONTAMENTOCELULA = $('#cbApontamentoCelula').is(':checked') ? 'S' : 'N'
        setor.CONSIDERARCUSTOS = $('#cbConsiderarCustos').is(':checked') ? 'S' : 'N'
        setor.PRECOLAVANDERIA = $('#cbPrecoLavanderia').is(':checked') ? 'S' : 'N'
        setor.FORMACAOKITS = $('#cbFormacaoKits').is(':checked') ? 'S' : 'N'
        setor.CONSIDERARRFID = $('#cbConsiderarRfid').is(':checked') ? 'S' : 'N'
        setor.CONSIDERARFILA = $('#cbConsiderarFila').is(':checked') ? 'S' : 'N'
        setor.CONSIDERARANALISE = $('#cbConsiderarAnalise').is(':checked') ? 'S' : 'N'
        setor.EXCLUIRCAIXA = $('#cbExcluirCaixa').is(':checked') ? 'S' : 'N'
        setor.ATUALIZARCAIXA = $('#cbAtualizarCaixa').is(':checked') ? 'S' : 'N'
        setor.PRECOFACCAO = $('#cbPrecoFaccao').is(':checked') ? 'S' : 'N'
        setor.MOVESTOQUE = $('#cbMovEstoque').is(':checked') ? 'S' : 'N'
        setor.OBRIGAPROGRAMACAO = $('#cbObrigaProgramacao').is(':checked') ? 'S' : 'N'
        setor.CONSESTOQUEVENDA = $('#cbConsideraEstoqueVenda').is(':checked') ? 'S' : 'N'
        setor.IMPETQCOMPOSI = $('#cbImprimeEtiquetaComposicao').is(':checked') ? 'S' : 'N'
        setor.HABILITAENFESTO = $('#cbHabilitarEnfesto').is(':checked') ? 'S' : 'N'
        setor.OBRIGALAUDO = $('#cbObrigaLaudo').is(':checked') ? 'S' : 'N'
        setor.GRAVARUNITARIO = $('#cbGravarUnitario').is(':checked') ? 'S' : 'N'
        setor.SUGEREPRECOANT = $('#cbSugerePrecoAnt').is(':checked') ? 'S' : 'N'

        if ($('#radioProduto').is(':checked')) {
            setor.TIPO = 'P'
        }
        if ($('#radioMaterial').is(':checked')) {
            setor.TIPO = 'M'
        }
        if ($('#radioVenda').is(':checked')) {
            setor.TIPO = 'V'
        }

        return setor;
    }

    $("#btnGravar").click(async function () {
        $.LoadingOverlay("show");
        try {
            if ($('#txtCodigo').val() == '') {
                msgAlerta(`Necessário informar um código.`);
                return;
            }
            if ($('#txtDescricao').val() == '') {
                msgAlerta(`Necessário informar uma descrição.`);
                return;
            }

            let setor = {};
            preencheClasseSetor(setor)

            let response = await requisicao('POST', '/sisplan/cadsetor/v1/cadsetor?', '', `JSON=${JSON.stringify(setor)}`, 15000);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            };

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }
            $.LoadingOverlay("hide");
            toastr.success(
                'Cadastro efetuado com sucesso!',
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.href = `${BASE_URI}/cadsetor`;
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });
        } catch (error) {
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados do setor.`);
        }
        finally {
            $.LoadingOverlay("hide");
        }
    });
});